#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

// LIST OF SYSTEM PARAMETERS

#define KAZ_DS_SP_J             192
#define KAZ_DS_SP_K             192

#define KAZ_DS_SP_G             "6007"
#define KAZ_DS_SP_G0            "23102151283542472555351033031857407110549489214984451103786304558150674606117088000"
#define KAZ_DS_SP_LG0         	274

#define KAZ_DS_SP_R             "6151"
#define KAZ_DS_SP_G1           "399620650696124709852000"
#define KAZ_DS_SP_LG1         	79

#define KAZ_DS_SP_Q             "15805027320208803894072603145771831246637343495"

#define KAZ_DS_SP_q             "5708990770823839524233143877797980545530986749"

// LIST OF PRECOMPUTED PARAMETERS
		
#define KAZ_DS_SP_PHIG1        "60408037934094090240000"
#define KAZ_DS_SP_PHIPHIG1     "11456568251237007360000"

#define KAZ_DS_SP_PHIQ          "3627887299833526965332723467399389511680000000"

#define KAZ_DS_SP_qQ			"90230755103690702091973211007922974222612910553804250618499942113585284663920884979406347755"
#define KAZ_DS_SP_PHIqQ			"20711575112338624928696946102003619446749681847468928622048198130495376119592271216640000000"

#define KAZ_DS_SP_G1Q			"6316015301971870405355111523122642561944284008905299941124934612740000"
#define KAZ_DS_SP_G1qQ			"36058073067339553985234252533698355039820968917784402221504061489000889035129447518174352692951449576156386582260000"

#define KAZ_DS_SP_RAN			4

#define KAZ_DS_SKBYTES    		48
#define KAZ_DS_V1BYTES          10
#define KAZ_DS_V2BYTES          39
#define KAZ_DS_SBYTES           48

extern void KAZ_DS_CRT(int t, mpz_t *c, mpz_t *modular, mpz_t crt);

extern void KAZ_DS_KEYGEN(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);

#endif // FILE_H_INCLUDED
